/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block;

import com.lothrazar.cyclic.config.ClientConfigCyclic;
import com.lothrazar.cyclic.registry.BlockRegistry;
import com.lothrazar.cyclic.util.UtilSound;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkHooks;

public class BlockCyclic
extends BaseEntityBlock {
    public static final BooleanProperty LIT = BooleanProperty.m_61465_((String)"lit");
    private boolean hasGui = false;
    private boolean hasFluidInteract = false;

    public BlockCyclic(BlockBehaviour.Properties properties) {
        super(properties);
        BlockRegistry.BLOCKSCLIENTREGISTRY.add(this);
    }

    public static boolean never(BlockState bs, BlockGetter bg, BlockPos pos) {
        return false;
    }

    public RenderShape m_7514_(BlockState st) {
        return RenderShape.MODEL;
    }

    protected BlockCyclic setHasGui() {
        this.hasGui = true;
        return this;
    }

    protected BlockCyclic setHasFluidInteract() {
        this.hasFluidInteract = true;
        return this;
    }

    public BlockEntity m_142194_(BlockPos p, BlockState st) {
        return null;
    }

    public BlockState rotate(BlockState state, LevelAccessor world, BlockPos pos, Rotation direction) {
        Direction oldDir;
        Direction newDir;
        if (state.m_61138_((Property)BlockStateProperties.f_61374_) && (newDir = direction.m_55954_(oldDir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_))) != Direction.UP && newDir != Direction.DOWN) {
            return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)newDir);
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61372_)) {
            oldDir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
            newDir = direction.m_55954_(oldDir);
            return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)newDir);
        }
        BlockState newState = state.m_60717_(direction);
        return newState;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (this.hasFluidInteract) {
            IFluidHandler handler;
            BlockEntity tankHere;
            if (!world.f_46443_ && (tankHere = world.m_7702_(pos)) != null && (handler = (IFluidHandler)tankHere.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, hit.m_82434_()).orElse(null)) != null) {
                if (FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)handler)) {
                    if (player instanceof ServerPlayer) {
                        UtilSound.playSoundFromServer((ServerPlayer)player, SoundEvents.f_11781_, 1.0f, 1.0f);
                    }
                    if (handler.getFluidInTank(0) != null) {
                        this.displayClientFluidMessage(player, handler);
                    }
                } else {
                    this.displayClientFluidMessage(player, handler);
                }
            }
            if (FluidUtil.getFluidHandler((ItemStack)player.m_21120_(hand)).isPresent()) {
                return InteractionResult.SUCCESS;
            }
        }
        if (this.hasGui) {
            if (!world.f_46443_) {
                BlockEntity tileEntity = world.m_7702_(pos);
                if (tileEntity instanceof MenuProvider) {
                    NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)((MenuProvider)tileEntity), (BlockPos)tileEntity.m_58899_());
                } else {
                    throw new IllegalStateException("Our named container provider is missing!");
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    private void displayClientFluidMessage(Player player, IFluidHandler handler) {
        if (((Boolean)ClientConfigCyclic.FLUID_BLOCK_STATUS.get()).booleanValue()) {
            player.m_5661_((Component)new TranslatableComponent(BlockCyclic.getFluidRatioName(handler)), true);
        }
    }

    public static String getFluidRatioName(IFluidHandler handler) {
        String ratio = handler.getFluidInTank(0).getAmount() + "/" + handler.getTankCapacity(0);
        if (!handler.getFluidInTank(0).isEmpty()) {
            ratio = ratio + " " + handler.getFluidInTank(0).getDisplayName().getString();
        }
        return ratio;
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            IItemHandler items;
            BlockEntity tileentity = worldIn.m_7702_(pos);
            if (tileentity != null && (items = (IItemHandler)tileentity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null)) != null) {
                for (int i = 0; i < items.getSlots(); ++i) {
                    Containers.m_18992_((Level)worldIn, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)items.getStackInSlot(i));
                }
                worldIn.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, worldIn, pos, newState, isMoving);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack stack, BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)new TranslatableComponent(this.m_7705_() + ".tooltip").m_130940_(ChatFormatting.GRAY));
    }

    public void registerClient() {
    }

    public static boolean isItem(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        return BlockCyclic.hasCapabilityDir(facing, world, facingPos, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
    }

    public static boolean isFluid(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        return BlockCyclic.hasCapabilityDir(facing, world, facingPos, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
    }

    public static boolean isEnergy(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        return BlockCyclic.hasCapabilityDir(facing, world, facingPos, CapabilityEnergy.ENERGY);
    }

    private static boolean hasCapabilityDir(Direction facing, LevelAccessor world, BlockPos facingPos, Capability<?> cap) {
        if (facing == null) {
            return false;
        }
        BlockEntity neighbor = world.m_7702_(facingPos);
        return neighbor != null && neighbor.getCapability(cap, facing.m_122424_()).orElse(null) != null;
    }
}

